# OpenAIImage

The `OpenAIImage` class represents an image generated by the OpenAI API. It provides properties for accessing the generated image in different formats and methods for converting this image to different types.

https://platform.openai.com/docs/api-reference/images/object

## Properties

| Property            | Type   | Description                                                                                  |
|---------------------|--------|----------------------------------------------------------------------------------------------|
| `url`               | Text   | The URL of the generated image, if `response_format` is `url` (default).                  |
| `b64_json`          | Text   | The base64-encoded JSON of the generated image, if `response_format` is `b64_json`.       |
| `revised_prompt`    | Variant| The prompt that was used to generate the image, if there was any revision to the prompt.    |

## Functions

### asBlob()

**asBlob**() : 4D.Blob

| Parameter        | Type    | Description                                             |
|------------------|---------|---------------------------------------------------------|
| Function result| 4D.Blob | Converts the generated image to a blob format based on its URL or base64-encoded JSON. |

#### Example Usage

```4d
var $blob:=$image.asBlob()
```

### asPicture()

**asPicture**() : Picture

| Parameter        | Type    | Description                                             |
|------------------|---------|---------------------------------------------------------|
| Function result| Picture | Creates a picture object from the blob converted image. |

#### Example Usage

```4d
var $picture:=$image.asPicture()
```

### saveToDisk()

**saveToDisk**(*file* : 4D.File) : Boolean

| Parameter        | Type    | Description                                             |
|------------------|---------|---------------------------------------------------------|
| *file*           | 4D.File | The file object where the image will be saved.          |
| Function result| Boolean | Returns `True` if the image is successfully saved.       |

Saves the image to disk, attempting to download it first if it is a URL. Returns `False` if it could not retrieve the image data.

#### Example Usage

```4d
var $success:=$image.saveToDisk(Folder(fk desktop folder).file("image.png"))
```
